
    // Masonary Grid Carousel
const masonryContainer = document.querySelector(".masonry");
if (masonryContainer) {
  // your masonry script goes here
  // Example: lightbox, fullscreen, share/download handling, etc.

 const images = document.querySelectorAll('.masonry img');
  const lightbox = document.getElementById('lightbox');
  const lightboxImg = document.getElementById('lightbox-img');
  const lightboxclBTN = document.getElementById('close');
  const prevBtn = document.getElementById('prev');
  const nextBtn = document.getElementById('next');
  const fullscreenBtn = document.getElementById('fullscreen');
  const shareBtn = document.getElementById('share');
  const shareDropdown = document.getElementById('share-dropdown');
  const downloadBtn = document.getElementById('download-img');

  let currentIndex = 0;
  let scale = 1;

  // Open lightbox
  images.forEach((img, index) => {
    img.addEventListener('click', () => {
      lightbox.style.display = 'flex';
      lightboxImg.src = img.src;
      currentIndex = index;
      scale = 1;
      lightboxImg.style.transform = `scale(${scale})`;
    });
  });

  // Close lightbox
  lightboxclBTN.addEventListener('click', () => {
    lightbox.style.display = 'none';
  });

  // Prev image
  prevBtn.addEventListener('click', () => {
    currentIndex = (currentIndex - 1 + images.length) % images.length;
    lightboxImg.src = images[currentIndex].src;
    resetZoom();
  });

  // Next image
  nextBtn.addEventListener('click', () => {
    currentIndex = (currentIndex + 1) % images.length;
    lightboxImg.src = images[currentIndex].src;
    resetZoom();
  });

  // Close on outside click
  lightbox.addEventListener('click', (e) => {
    if (e.target === lightbox) {
      lightbox.style.display = 'none';
    }
  });

  // Fullscreen toggle
  fullscreenBtn.addEventListener('click', () => {
    if (!document.fullscreenElement) {
      lightbox.requestFullscreen();
      fullscreenBtn.textContent = "⤢";
    } else {
      document.exitFullscreen();
      fullscreenBtn.textContent = "⛶";
    }
  });

  // Share dropdown toggle
  shareBtn.addEventListener('click', (e) => {
    e.stopPropagation();
    shareDropdown.style.display =
      shareDropdown.style.display === "flex" ? "none" : "flex";
  });

  // Hide dropdown on outside click
  document.addEventListener('click', () => {
    shareDropdown.style.display = "none";
  });

  // Update share links dynamically
  function updateShareLinks(url) {
    document.getElementById('share-fb').href =
      `https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(url)}`;
    document.getElementById('share-twitter').href =
      `https://twitter.com/intent/tweet?url=${encodeURIComponent(url)}`;
    document.getElementById('share-pinterest').href =
      `https://pinterest.com/pin/create/button/?url=${encodeURIComponent(url)}&media=${encodeURIComponent(url)}`;
    downloadBtn.href = url;
    downloadBtn.setAttribute("download", "image.jpg");
  }

  // Update share links on image change
  function refreshShareLinks() {
    updateShareLinks(images[currentIndex].src);
  }

  // When download is clicked
downloadBtn.addEventListener('click', async (e) => {
  e.preventDefault();               // prevent default anchor behavior
  e.stopPropagation();
  const url = images[currentIndex].src;
  await downloadImage(url);         // triggers actual download
  shareDropdown.style.display = 'none';
});
  // Zoom controls
  document.getElementById('zoom-in').addEventListener('click', () => {
    scale += 0.2;
    lightboxImg.style.transform = `scale(${scale})`;
  });

  document.getElementById('zoom-out').addEventListener('click', () => {
    if (scale > 0.4) {
      scale -= 0.2;
      lightboxImg.style.transform = `scale(${scale})`;
    }
  });

  function resetZoom() {
    scale = 1;
    lightboxImg.style.transform = `scale(${scale})`;
    refreshShareLinks();
  }

  // Initial update
  refreshShareLinks();
  
    console.log("Masonry active");
}







//  Sticky Menu navbar------------
window.addEventListener("scroll", function() {
  const navbar = document.getElementById("navbar");
  if (window.scrollY > 100) { // scroll distance
    navbar.classList.add("sticky");
  } else {
    navbar.classList.remove("sticky");
  }
});
// Mobile Menu-----------------------------
const menuBtn = document.getElementById("menuToggle");
const navbarmob = document.getElementById("navbar");

menuBtn.addEventListener("click", () => {
navbarmob.classList.toggle("active");
});
//  Search section------------
 const searchBtn = document.getElementById('openSearch');
 const closesearch = document.getElementById('Searchcl');
 const searchOverlay = document.getElementById('searchOverlay');

  searchBtn.addEventListener('click', () => {
    searchOverlay.classList.add('active');
    document.querySelector('.search-overlay input').focus();
  });

  closesearch.addEventListener('click', () => {
    searchOverlay.classList.remove('active');
  });

  // Close search overlay on Escape key press
  document.addEventListener('keydown', (e) => {
    if (e.key === 'Escape') {
      searchOverlay.classList.remove('active');
    }
  });

    
// Home Banner-------------------------------
 const BannerImage = document.getElementById('BannerImage');
 const BannerVideo = document.getElementById('BannerVideo');
 BannerVideo.pause();

setTimeout(() => {
    BannerImage.classList.add('fade-out');
    BannerVideo.play();
  }, 3000); // 3000 ms = 3 seconds

// Home image Slider------------------------------
const track = document.querySelector('.carousel-track');
    const originalSlides = Array.from(track.children);
    const dotsContainer = document.querySelector('.carousel-dots');

    let visibleSlides = window.innerWidth <= 1024 ? 2 : 5;
    let index = visibleSlides; // start after prepended clones
    let slideWidth;

    // Clone first and last N slides (equal to visible count)set
    function cloneSlides() {
      const firstClones = originalSlides.slice(0, visibleSlides).map(s => s.cloneNode(true));
      const lastClones = originalSlides.slice(-visibleSlides).map(s => s.cloneNode(true));

      firstClones.forEach(c => track.appendChild(c));
      lastClones.forEach(c => track.insertBefore(c, track.firstChild));
    }
    cloneSlides();

    let allSlides = Array.from(track.children);

    // Create dots
    originalSlides.forEach((_, i) => {
      const dot = document.createElement('span');
      dot.classList.add('dot');
      if (i === 0) dot.classList.add('active');
      dot.addEventListener('click', () => {
        index = i + visibleSlides;
        updateCarousel();
      });
      dotsContainer.appendChild(dot);
    });
    const dots = Array.from(document.querySelectorAll('.dot'));

    function updateCarousel(animate = true) {
      slideWidth = allSlides[0].getBoundingClientRect().width;
      track.style.transition = animate ? "transform 0.6s ease" : "none";
      track.style.transform = `translateX(-${index * slideWidth}px)`;

      // update dots
      dots.forEach(dot => dot.classList.remove('active'));
      let dotIndex = (index - visibleSlides) % originalSlides.length;
      if (dotIndex < 0) dotIndex += originalSlides.length;
      dots[dotIndex].classList.add('active');
    }

    function autoSlide() {
      index++;
      updateCarousel();
    }

    track.addEventListener('transitionend', () => {
      if (index >= allSlides.length - visibleSlides) {
        index = visibleSlides;
        updateCarousel(false);
      }
      if (index < visibleSlides) {
        index = allSlides.length - visibleSlides * 2;
        updateCarousel(false);
      }
    });

    setInterval(autoSlide, 3000);
    window.addEventListener('resize', () => {
      visibleSlides = window.innerWidth <= 1024 ? 2 : 5;
      index = visibleSlides;
      updateCarousel(false);
    });

    updateCarousel(false);



// Sticky contact toggle
function toggleContact() {
      const tray = document.getElementById("contactTray");
      const tglBtn = document.getElementById("toggle-btn");
      const tglArrow = document.getElementById("tgArrow");
      tray.classList.toggle("toggleTray");
      tglBtn.classList.toggle("togglebtn-slide");
      tglArrow.classList.toggle("tgrotate");
    }
    
// Contact Form Validation
 const form = document.getElementById('contactForm');
    const formMessage = document.getElementById('formMessage');

    form.addEventListener('submit', function(event) {
      event.preventDefault();

      const name = document.getElementById('name').value.trim();
      const email = document.getElementById('email').value.trim();
      const message = document.getElementById('message').value.trim();

      if (name === "" || email === "" || message === "") {
        formMessage.textContent = "Please fill in all fields.";
        formMessage.className = "message error";
        return;
      }

      // Simple email check
      const emailPattern = /^[^ ]+@[^ ]+\.[a-z]{2,3}$/;
      if (!email.match(emailPattern)) {
        formMessage.textContent = "Please enter a valid email address.";
        formMessage.className = "message error";
        return;
      }

      // ✅ Success message
      formMessage.textContent = "Message sent successfully!";
      formMessage.className = "message success";

      // Reset form
      form.reset();
    });




// ---------------------------------------------------------------
