<?php
session_start();
include 'dbconnection.php';   // अगर ये mysqli connection देता है तो नीचे वाली mysqli_connect वाली लाइन हटा दो
include("checklogin.php");
check_login();
include('db_connect.php');    // अगर ये तुम्हारे पास DB connection देता है तो उपयोग कर लो

// ----- OPTIONAL: increase limits for large image processing -----
@ini_set('memory_limit', '512M'); // अगर बहुत बड़ी फोटो हैं तो और बढ़ाओ
@set_time_limit(0);

if(isset($_POST['upload'])) {

    // ----------------- CONFIG -----------------
    define('GW_UPLOADPATH1', __DIR__ . '/../Assets/shoots/'); // absolute path बेहतर रहता है
    if(!is_dir(GW_UPLOADPATH1)) mkdir(GW_UPLOADPATH1, 0755, true);

    $cat = isset($_POST['cat']) ? trim($_POST['cat']) : '';

    $max_width = 1600;
    $max_height = 1200;
    $quality = 85;

    // ----------------- DB: create mysqli connection (replace with your creds OR use existing connection) -----------------
    // अगर include किए गए फाइल में already $conn (mysqli) या $dbh (PDO) है, तो वही उपयोग करो।
    $db_host = 'localhost';
    $db_user = 'root';
    $db_pass = '';
    $db_name = 'lolzz';
    $conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
    if ($conn->connect_error) {
        die("DB connection failed: " . $conn->connect_error);
    }

    // ----------------- helper functions -----------------
    function fix_orientation($file, $image) {
        if (!function_exists('exif_read_data')) return $image;
        $exif = @exif_read_data($file);
        if(!$exif || !isset($exif['Orientation'])) return $image;

        switch($exif['Orientation']) {
            case 3: $image = imagerotate($image, 180, 0); break;
            case 6: $image = imagerotate($image, -90, 0); break;
            case 8: $image = imagerotate($image, 90, 0); break;
        }
        return $image;
    }

    function convert_and_resize($tmp, $dest, $max_w, $max_h, $quality) {
        $info = @getimagesize($tmp);
        if (!$info) return false;

        list($ow, $oh, $type) = $info;

        switch ($type) {
            case IMAGETYPE_JPEG: $src = @imagecreatefromjpeg($tmp); break;
            case IMAGETYPE_PNG:  $src = @imagecreatefrompng($tmp); break;
            case IMAGETYPE_GIF:  $src = @imagecreatefromgif($tmp); break;
            case IMAGETYPE_WEBP:
                if(function_exists('imagecreatefromwebp')) {
                    $src = @imagecreatefromwebp($tmp);
                } else return false;
                break;
            default:
                return false;
        }

        if(!$src) return false;

        if($type == IMAGETYPE_JPEG) {
            $src = fix_orientation($tmp, $src);
        }

        // calculate new dimensions preserving aspect ratio
        $ratio = $ow / $oh;
        $nw = $ow; $nh = $oh;
        if($nw > $max_w) { $nw = $max_w; $nh = intval($nw / $ratio); }
        if($nh > $max_h) { $nh = $max_h; $nw = intval($nh * $ratio); }

        $dst = imagecreatetruecolor($nw, $nh);

        // white background for formats without alpha (conversion to JPG/WebP)
        $white = imagecolorallocate($dst, 255, 255, 255);
        imagefilledrectangle($dst, 0, 0, $nw, $nh, $white);

        // preserve transparency for PNG/GIF by copying with white background (already filled)
        imagecopyresampled($dst, $src, 0,0,0,0, $nw,$nh,$ow,$oh);

        // try WEBP if available
        $saved_name = false;
        if(function_exists('imagewebp')) {
            $webp_path = preg_replace('/\.[^.]+$/', '.webp', $dest);
            if (@imagewebp($dst, $webp_path, $quality)) {
                $saved_name = basename($webp_path);
            }
        }

        // fallback to JPG
        if (!$saved_name) {
            if (@imagejpeg($dst, $dest, $quality)) {
                $saved_name = basename($dest);
            } else {
                $saved_name = false;
            }
        }

        imagedestroy($src);
        imagedestroy($dst);
        return $saved_name;
    }

    // ----------------- PROCESS UPLOADS -----------------
    // check that files were sent and loop
    if(!isset($_FILES['file1'])) {
        echo "<script>alert('Images Not Selected');history.back();</script>";
        exit;
    }

    // Useful debug: check PHP upload limitations in runtime
    // echo ini_get('upload_max_filesize'), ini_get('post_max_size'), ini_get('max_file_uploads');

    $files = $_FILES['file1'];
    $numFiles = is_array($files['name']) ? count($files['name']) : 0;

    // prepared statement for insert
    $stmt = $conn->prepare("INSERT INTO gallery (cat, images, status) VALUES (?, ?, 'Active')");
    if (!$stmt) {
        die("Prepare failed: " . $conn->error);
    }

    $inserted = 0;
    for($i = 0; $i < $numFiles; $i++) {
        $error = $files['error'][$i];
        if($error !== UPLOAD_ERR_OK) {
            // skip file but you may want to log error
            // possible errors: UPLOAD_ERR_INI_SIZE, UPLOAD_ERR_FORM_SIZE, UPLOAD_ERR_PARTIAL, UPLOAD_ERR_NO_FILE, UPLOAD_ERR_NO_TMP_DIR, etc.
            continue;
        }

        $tmp = $files['tmp_name'][$i];
        if(!is_uploaded_file($tmp)) continue;

        // create unique base name (use microtime + random)
        $uniq = microtime(true) . '_' . rand(1000,9999);
        $newname_jpg = $uniq . '.jpg';
        $target_jpg = GW_UPLOADPATH1 . $newname_jpg;

        $saved_file = convert_and_resize($tmp, $target_jpg, $max_width, $max_height, $quality);

        if($saved_file) {
            // save record
            $stmt->bind_param('ss', $cat, $saved_file);
            if($stmt->execute()) $inserted++;
            // else log error
        }
    }

    $stmt->close();
    $conn->close();

    if($inserted > 0) {
        echo "<script>alert('Images Added with Compression! Total: {$inserted}');</script>";
    } else {
        echo "<script>alert('Images Not Selected Check file sizes / PHP settings.');</script>";
    }
    echo "<script>location.href='addpost.php';</script>";
    exit;
}
?>




<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
<?php include('titel.php') ?>
	<!-- Bootstrap Styles-->
    <link href="assets/css/bootstrap.css" rel="stylesheet" />
     <!-- FontAwesome Styles-->
    <link href="assets/css/font-awesome.css" rel="stylesheet" />
        <!-- Custom Styles-->
    <link href="assets/css/custom-styles.css" rel="stylesheet" />
     <!-- Google Fonts-->
   <link href='http://fonts.googleapis.com/css?family=Open+Sans' rel='stylesheet' type='text/css' />
</head>
<body>
    <div id="wrapper">
        <?php include('header.php') ?>
        <!--/. NAV TOP  -->
        <?php include('menu.php') ?>
        <!-- /. NAV SIDE  -->
        <div id="page-wrapper" >
            <div id="page-inner">
			 <div class="row">
                    <div class="col-md-12">
                        <h1 class="page-header">
                            Post
                        </h1>
                    </div>
                </div> 
                
                
                <div class="row">
                <div class="col-md-12">
                    <!-- Advanced Tables -->
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            Post
                        </div>
                        <div class="panel-body">
   
                        
                            <form method="post" enctype="multipart/form-data" onsubmit="return confirm('Are you sure want to save ?');">

<div class="form-group">
    <label>Category Name</label>
    <select class="form-control" name="cat">
        <?php
        include("db_connect.php");
        $sql="select * from cat order by id asc";
        $res=mysql_query($sql);
        while($row=mysql_fetch_array($res)) { ?>
            <option value="<?php echo $row["catname"];?>">
                <?php echo $row["catname"];?>
            </option>
        <?php } ?>
    </select>
</div>

<div class="form-group">
    <label>Post Images</label>
    <input type="file" name="file1[]" multiple>
</div>

<button type="submit" name="upload" class="btn btn-info">Add</button>

</form>

                        
                            </div>
                             
                        </div>
                    </div>
                    <!--End Advanced Tables -->
                </div>
                

            </div>
                
                
                 <!-- /. ROW  -->
				<?php include('footer.php') ?>
				</div>
             <!-- /. PAGE INNER  -->
            </div>
         <!-- /. PAGE WRAPPER  -->
        </div>
     <!-- /. WRAPPER  -->
    <!-- JS Scripts-->
    <!-- jQuery Js -->
    <script src="assets/js/jquery-1.10.2.js"></script>
      <!-- Bootstrap Js -->
    <script src="assets/js/bootstrap.min.js"></script>
    <!-- Metis Menu Js -->
    <script src="assets/js/jquery.metisMenu.js"></script>
      <!-- Custom Js -->
    <script src="assets/js/custom-scripts.js"></script>
    
   
</body>

</html>

