<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title>Auto Fix YouTube Embed</title>

<script>
function fixEmbed() {
    let ta = document.getElementById("embed");
    let code = ta.value;

    if(code.trim() == "") return;

    // your fixed size
    let myWidth = "595";   // ← yahan apna width
    let myHeight = "335"; // ← yahan apni height

    // Replace width & height in iframe
    code = code.replace(/width="[^"]*"/gi, `width="${myWidth}"`);
    code = code.replace(/height="[^"]*"/gi, `height="${myHeight}"`);

    // For inline style width/height
    code = code.replace(/width:\s*[^;"]*;?/gi, `width:${myWidth};`);
    code = code.replace(/height:\s*[^;"]*;?/gi, `height:${myHeight};`);

    // Update textarea
    ta.value = code;
}

window.onload = () => {
    let ta = document.getElementById("embed");

    // Auto run after paste
    ta.addEventListener("paste", () => {
        setTimeout(fixEmbed, 50);
    });

    // Auto run when typing (optional)
    ta.addEventListener("input", fixEmbed);
};
</script>

</head>

<body>

<h3>Paste YouTube Embed Code Below:</h3>

<textarea id="embed" style="width:100%; height:150px;"></textarea>

</body>
</html>
